package com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestHandler;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.ResponseMessage;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientData;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientDataCollection;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.DomainServiceRegistry;

public abstract class AbstractFetchPatientDataListRequestHandler<TDataLayer, Ts extends PatientDataCollection<T>, T extends PatientData> implements RequestHandler {
	@Override
	public ResponseMessage handle(RequestMessage requestMessage) {
		PatientDataFetchRequestReader messageReader = PatientDataFetchRequestReader.fromRequest(requestMessage);
		TDataLayer datalayer = getDataLayer(requestMessage);
		Ts patientData = invokeDataLayerToFetchList(datalayer, requestMessage, messageReader);
		return PatientDataResponseBuilder.fromPatientData(patientData).build();
	}

	protected abstract Ts invokeDataLayerToFetchList(TDataLayer datalayer, RequestMessage requestMessage, PatientDataFetchRequestReader messageReader);

	private TDataLayer getDataLayer(RequestMessage requestMessage) {
		DomainServiceRegistry serviceRegistry = new DomainServiceRegistry();
		return serviceRegistry.getDataLayerByMessage(requestMessage);
	}
}
