package com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.datatransfer;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.ResponseMessage;
import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.MhpObjectFactory;

public class TransferObjectResponseReader<Ts extends DomainTransferObjectCollection<T>, T extends DomainTransferObject> {
	
	protected ResponseMessage response;
	
	protected TransferObjectResponseReader(ResponseMessage response) {
		this.response = response;
	}
	
	public static <Ts extends DomainTransferObjectCollection<T>, T extends DomainTransferObject>TransferObjectResponseReader<Ts, T> fromReponse(ResponseMessage response) {
		return new TransferObjectResponseReader<Ts, T>(response);
	}
	
	public Ts getDataList() {
		return response.getValue("data-list");
	}
	
	public Ts getDataListNoNull(Class<Ts> type) {
		Ts dataList = getDataList();
		if(dataList == null) 
			dataList = MhpObjectFactory.initializeByType(type);
		return dataList;
	}
	
	public T getDataItem() {
		return response.getValue("data-item");
	}
}
