package com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.datatransfer;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.ResponseMessage;
import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.MhpObjectFactory;

public class TransferObjectResponseBuilder {
	protected ResponseMessage response;
	
	protected TransferObjectResponseBuilder(ResponseMessage response) {
		this.response = response;
	}
	
	public static <Ts extends DomainTransferObjectCollection<T>, T extends DomainTransferObject> TransferObjectResponseBuilder fromResponseData(Ts dataList) {
		ResponseMessage response = new ResponseMessage();
		TransferObjectResponseBuilder builder = new TransferObjectResponseBuilder(response);
		builder.append(dataList);
		
		return builder;
	}
	
	public static <Ts extends DomainTransferObjectCollection<T>, T extends DomainTransferObject> TransferObjectResponseBuilder fromResponseData(T dataItem) {
		ResponseMessage response = new ResponseMessage();
		TransferObjectResponseBuilder builder = new TransferObjectResponseBuilder(response);
		builder.setResponseData(dataItem);
		return builder;
	}
	
	
	public <Ts extends DomainTransferObjectCollection<T>, T extends DomainTransferObject> TransferObjectResponseBuilder append(Ts dataList) {
		Ts existingData = response.getValue("data-list");
		
		if(existingData == null) {
			@SuppressWarnings("unchecked")
			Ts aggregate = (Ts) MhpObjectFactory.initializeByType(dataList.getClass());
			aggregate.addAll(dataList);
		} else {
			existingData.addAll(dataList);
		}
		
		return this;
	}
	
	public <T extends DomainTransferObject> TransferObjectResponseBuilder setResponseData(T dataItem) {
		response.setValue("data-item", dataItem);
		return this;
	}
	
	public ResponseMessage build() {
		return response;
	}
}
