package com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.datatransfer;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;

public class TransferObjectRequestReader {
	protected RequestMessage request;
	
	protected TransferObjectRequestReader(RequestMessage request) {
		this.request = request;
	}
	
	public static TransferObjectRequestReader fromRequest(RequestMessage request) {
		return new TransferObjectRequestReader(request);
	}
	
	public String getMessageId() {
		return request.getMessageId();
	}
	
	public String getType() {
		return request.getType();
	}
	
	public String getDomain() {
		return request.getValue("domain");
	}
	
	@SuppressWarnings("unchecked")
	public <T> T getValueForKey(String key) {
		return (T) request.getValue(key);
	}
}
