package com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.datatransfer;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.utility.NullChecker;

public class TransferObjectFetchRequestBuilder {
	protected RequestMessage request;
	
	protected TransferObjectFetchRequestBuilder(RequestMessage request) {
		this.request = request;
	}
	
	public static TransferObjectFetchRequestBuilder forRetrieveList() {
		RequestMessage request = new RequestMessage();
		TransferObjectFetchRequestBuilder  builder = new TransferObjectFetchRequestBuilder(request);
		request.setType("FetchListOfData");
		return builder;
	}
	
	public static TransferObjectFetchRequestBuilder forRetrieveSingleById() {
		RequestMessage request = new RequestMessage();
		TransferObjectFetchRequestBuilder  builder = new TransferObjectFetchRequestBuilder(request);
		request.setType("FetchById");
		return builder;
	}
	
	public TransferObjectFetchRequestBuilder forDomain(String domain) {
		request.setValue("domain", domain);
		return this;
	}
	
	public TransferObjectFetchRequestBuilder setValue(String key, String value) {
		request.setValue(key, value);
		return this;
	}
	
	public RequestMessage build() {
		if (NullChecker.isNullish(request.getMessageId()))
			throw new IllegalArgumentException("ID is a required field");
		if (NullChecker.isNullish(request.getType()))
			throw new IllegalArgumentException("Type is a required field");
		return request;
	}
}
