package com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.datatransfer;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.*;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.*;
import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.DomainServiceRegistry;

public abstract class AbstractFetchTransferObjectListHandler<TDataLayer, Ts extends DomainTransferObjectCollection<T>, T extends DomainTransferObject>  implements RequestHandler {
	
	@Override
	public ResponseMessage handle(RequestMessage requestMessage) {
		PatientDataFetchRequestReader messageReader = PatientDataFetchRequestReader.fromRequest(requestMessage);
		TDataLayer datalayer = getDataLayer(requestMessage);
		Ts dataList = invokeDataLayerToFetchList(datalayer, requestMessage, messageReader);
		return TransferObjectResponseBuilder.fromResponseData(dataList).build();
	}

	protected abstract Ts invokeDataLayerToFetchList(TDataLayer datalayer, RequestMessage requestMessage, PatientDataFetchRequestReader messageReader);

	private TDataLayer getDataLayer(RequestMessage requestMessage) {
		DomainServiceRegistry serviceRegistry = new DomainServiceRegistry();
		return serviceRegistry.getDataLayerByMessage(requestMessage);
	}
}
