package com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router;

import java.util.concurrent.TimeUnit;

import org.springframework.beans.factory.NoSuchBeanDefinitionException;

import com.agilex.healthcare.mobilehealthplatform.serviceregistry.DomainServiceRegistry;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.MhpObjectFactory;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Timer;
import com.yammer.metrics.core.TimerContext;

public class Router {
	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(Router.class);

	private DomainServiceRegistry serviceRegistry;

	public Router() {
		this(MhpObjectFactory.getInstance());
	}

	public Router(MhpObjectFactory mhpObjectFactory) {
		this.serviceRegistry = new DomainServiceRegistry(mhpObjectFactory);
	}

	public ResponseMessage execute(RequestMessage request) {
//		logger.debug(String.format("router received request to process message [request=%s]", request));

		RequestHandler handler = getRequestHandler(request);

//		logger.debug(String.format("router begin delegation to handler [request=%s][handler=%s]", request, handler));
		ResponseMessage response = executeHandler(request, handler);
//		logger.debug(String.format("router received response from handler [request=%s][handler=%s][response=%s]", request, handler, response));

		response.setRequestMessage(request);

//		logger.debug(String.format("router complete with processing request [request=%s][handler=%s][response=%s]", request, handler, response));
		return response;
	}

	private ResponseMessage executeHandler(RequestMessage request, RequestHandler handler) {
		final Counter messageCounter = Metrics.newCounter(Router.class, "router-messageCount-total");
		messageCounter.inc();

		final Counter totalPendingJobsCounter = Metrics.newCounter(Router.class, "router-total-pendingjobs");
		totalPendingJobsCounter.inc();

		final Counter pendingJobsForThisMethod = Metrics.newCounter(handler.getClass(), "router-" + request.getType() + "-pendingjobs");
		pendingJobsForThisMethod.inc();

		final Timer timerForThisMessageHandler = Metrics.newTimer(handler.getClass(), "router-" + request.getType() + "-timer", TimeUnit.MILLISECONDS, TimeUnit.SECONDS);
		final TimerContext contextForThisMethod = timerForThisMessageHandler.time();

		ResponseMessage response;
		try {
			response = handler.handle(request);
		} finally {
			contextForThisMethod.stop();
			pendingJobsForThisMethod.dec();
			totalPendingJobsCounter.dec();
		}

		return response;
	}

	private RequestHandler getRequestHandler(RequestMessage requestMessage) {
		RequestHandler handler;
		try {
			handler = serviceRegistry.getRequestHandlerByRequestType(requestMessage);
		} catch (NoSuchBeanDefinitionException e) {
			throw new RuntimeException("Unable to determine handler for message.");
		}
		return handler;
	}

}
