package com.agilex.healthcare.mobilehealthplatform.datalayer.dailyevent;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dailyevents.DailyEventDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.AbstractFetchPatientDataRequestHandler;
import com.agilex.healthcare.mobilehealthplatform.domain.*;

public class FetchDailyEventRequestHandler extends AbstractFetchPatientDataRequestHandler<DailyEventDataLayer, DailyEvent> {

	@Override
	protected DailyEvent invokeDataLayerToFetchSingleItem(DailyEventDataLayer datalayer, PatientIdentifier patientIdentifier, String dataId, RequestMessage requestMessage) {
		return datalayer.getDailyEvent(patientIdentifier.getUniqueId(), dataId);
	}

}
