package com.agilex.healthcare.mobilehealthplatform.datalayer.dailyevent;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dailyevents.DailyEventDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.AbstractFetchPatientDataListRequestHandler;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataFetchRequestReader;
import com.agilex.healthcare.mobilehealthplatform.domain.DailyEvent;
import com.agilex.healthcare.mobilehealthplatform.domain.DailyEvents;

public class FetchDailyEventListRequestHandler extends AbstractFetchPatientDataListRequestHandler<DailyEventDataLayer, DailyEvents, DailyEvent> {

	@Override
	protected DailyEvents invokeDataLayerToFetchList(DailyEventDataLayer datalayer, RequestMessage requestMessage, PatientDataFetchRequestReader messageReader) {
		return datalayer.getDailyEvents(messageReader.getPatientId(), messageReader.getDateFilter());
	}

}
