package com.agilex.healthcare.mobilehealthplatform.datalayer.dailyevent;

import com.agilex.healthcare.mobilehealthplatform.datalayer.JournalEventsDataService;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.Router;
import com.agilex.healthcare.mobilehealthplatform.domain.DailyEvent;
import com.agilex.healthcare.mobilehealthplatform.domain.DailyEvents;
import com.agilex.healthcare.mobilehealthplatform.domain.ValidationResult;
import com.agilex.healthcare.mobilehealthplatform.restservice.exception.InvalidDailyEventsException;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;
import com.agilex.healthcare.mobilehealthplatform.validator.dailyevents.DailyEventValidator;

public class DailyEventDataService extends JournalEventsDataService<DailyEvents, DailyEvent> {

	public DailyEventDataService() {
		this(new Router());
	}

	public DailyEventDataService(Router router) {
		super(router, Domain.dailyevent, DailyEvents.class, new DailyEventValidator());
	}

	@Override
	protected void throwValidationException(ValidationResult<DailyEvent> validationResult) {
		throw new InvalidDailyEventsException(validationResult.getErrors());
	}

}
