package com.agilex.healthcare.mobilehealthplatform.datalayer.customview;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.AbstractFetchPatientDataListRequestHandler;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataFetchRequestReader;
import com.agilex.healthcare.mobilehealthplatform.domain.CustomView;
import com.agilex.healthcare.mobilehealthplatform.domain.CustomViewList;

public class FetchCustomViewsRequestHandler extends AbstractFetchPatientDataListRequestHandler<CustomViewDataLayer, CustomViewList, CustomView> {

	@Override
	protected CustomViewList invokeDataLayerToFetchList(CustomViewDataLayer datalayer, RequestMessage requestMessage, PatientDataFetchRequestReader messageReader) {
		return datalayer.fetchCustomViews(messageReader.getPatientIdentifier().getUniqueId());
	}

}
