package com.agilex.healthcare.mobilehealthplatform.datalayer.customview;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.ResponseMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.Router;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataFetchRequestBuilder;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataResponseReader;
import com.agilex.healthcare.mobilehealthplatform.domain.CustomView;
import com.agilex.healthcare.mobilehealthplatform.domain.CustomViewList;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;

public class CustomViewDataService {
	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(CustomViewDataService.class);

	private Router router;

	public CustomViewDataService() {
		this.router = new Router();
	}

	public CustomViewDataService(Router router) {
		this.router = router;
	}
	
	public CustomViewList fetchCustomViews(PatientIdentifier patientIdentifier, ScopeFilter scopeFilter) {
		logger.debug("fetchCustomViews patientIdentifier");

		RequestMessage request = PatientDataFetchRequestBuilder.forRetrieveList().forDomain(Domain.customview).forPatientIdentifier(patientIdentifier)
				.forScopeFilter(scopeFilter).setChildMessageType("{domain}.fetchCustomViews").build();
	
		ResponseMessage responseMessage = router.execute(request);
		CustomViewList customViewList = PatientDataResponseReader.<CustomViewList, CustomView> fromResponse(responseMessage).getDataListNoNull(
				CustomViewList.class);

		return customViewList;

	}
	
}
