package com.agilex.healthcare.mobilehealthplatform.datalayer.contactlog;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.AbstractFetchPatientDataRequestHandler;
import com.agilex.healthcare.mobilehealthplatform.domain.*;

public class FetchContactLogRequestHandler extends AbstractFetchPatientDataRequestHandler<ContactLogDataLayer, ContactLog> {

	@Override
	protected ContactLog invokeDataLayerToFetchSingleItem(ContactLogDataLayer datalayer, PatientIdentifier patientIdentifier, String dataId, RequestMessage requestMessage) {
		return datalayer.getContactLog(patientIdentifier.getUniqueId(), dataId);
	}

}
