package com.agilex.healthcare.mobilehealthplatform.datalayer.contactlog;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.AbstractFetchPatientDataListRequestHandler;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataFetchRequestReader;
import com.agilex.healthcare.mobilehealthplatform.domain.ContactLog;
import com.agilex.healthcare.mobilehealthplatform.domain.ContactLogs;

public class FetchContactLogListRequestHandler extends AbstractFetchPatientDataListRequestHandler<ContactLogDataLayer, ContactLogs, ContactLog> {

	@Override
	protected ContactLogs invokeDataLayerToFetchList(ContactLogDataLayer datalayer, RequestMessage requestMessage, PatientDataFetchRequestReader messageReader) {
		return datalayer.getContactLogs(messageReader.getPatientId(), messageReader.getDateFilter());
	}

}
