package com.agilex.healthcare.mobilehealthplatform.datalayer.calendar;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestHandler;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.ResponseMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataEditRequestReader;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataResponseBuilder;
import com.agilex.healthcare.mobilehealthplatform.domain.CalendarEvent;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.DomainServiceRegistry;

public class SaveCalendarEventListRequestHandler implements RequestHandler {

	@Override
	public ResponseMessage handle(RequestMessage requestMessage) {
		PatientDataEditRequestReader<CalendarEvent> messageReader = PatientDataEditRequestReader.<CalendarEvent> fromRequest(requestMessage);
		CalendarEventDataLayer datalayer = getDataLayer(requestMessage);

		CalendarEvent modifiedCalendarEvent = datalayer.saveCalendarEvent(messageReader.getData());
		return PatientDataResponseBuilder.fromPatientData(modifiedCalendarEvent).build();
	}

	private CalendarEventDataLayer getDataLayer(RequestMessage requestMessage) {
		DomainServiceRegistry serviceRegistry = new DomainServiceRegistry();
		return serviceRegistry.getDataLayerByMessage(requestMessage);
	}
}
