package com.agilex.healthcare.mobilehealthplatform.datalayer.calendar;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestHandler;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.ResponseMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataFetchRequestReader;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataResponseBuilder;
import com.agilex.healthcare.mobilehealthplatform.domain.CalendarEvents;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.DomainServiceRegistry;

public class FetchCalendarEventListRequestHandler implements RequestHandler {

	@Override
	public ResponseMessage handle(RequestMessage requestMessage) {
		PatientDataFetchRequestReader messageReader = PatientDataFetchRequestReader.fromRequest(requestMessage);
		CalendarEventDataLayer datalayer = getDataLayer(requestMessage);
		CalendarEvents calendarEvents = datalayer.fetchCalendarEvents(messageReader.getPatientId());
		return PatientDataResponseBuilder.fromPatientData(calendarEvents).build();
	}

	private CalendarEventDataLayer getDataLayer(RequestMessage requestMessage) {
		DomainServiceRegistry serviceRegistry = new DomainServiceRegistry();
		return serviceRegistry.getDataLayerByMessage(requestMessage);
	}
}
