package com.agilex.healthcare.mobilehealthplatform.datalayer.calendar;

import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ServiceRegistry;

public class CalendarKeyDataService {
	private CalendarKeyDataLayer datalayer;

	public CalendarKeyDataService() {
		datalayer = ServiceRegistry.getInstance().getPrimaryCommunity().getDataLayerFactory().getCalendarKeyDataLayer();
	}
	
	public CalendarKeyDataService(CalendarKeyDataLayer datalayer) {
		this.datalayer = datalayer;
	}
	
	public String fetchKeyByPatient(PatientIdentifier patientIdentifier) {
		return datalayer.fetchKeyByPatient(patientIdentifier);
	}

	public String fetchPatientByKey(String key) {
		return datalayer.fetchPatientByKey(key);
	}

	public String createKeyForPatient(PatientIdentifier patientIdentifier) {
		return datalayer.createKeyForPatient(patientIdentifier);
	}

	public void deleteKeyForPatient(PatientIdentifier patientIdentifier, String key) {
		datalayer.deleteKeyForPatient(patientIdentifier);
	}
}
