package com.agilex.healthcare.mobilehealthplatform.datalayer.calendar;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.ResponseMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.Router;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataEditRequestBuilder;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataFetchRequestBuilder;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataResponseReader;
import com.agilex.healthcare.mobilehealthplatform.domain.CalendarEvent;
import com.agilex.healthcare.mobilehealthplatform.domain.CalendarEvents;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;

/***
 * This covers calendar events created by the veteran. These are items to show
 * up on their calendar that are not "appointments"
 * 
 * @author ???
 * 
 */
public class CalendarEventDataService {

	private Router router = new Router();;

	public CalendarEventDataService() {
	}

	public CalendarEvents getCalendarEvents(PatientIdentifier patientIdentifier, ScopeFilter scopeFilter) {
		RequestMessage request = PatientDataFetchRequestBuilder.forRetrieveList().forDomain(Domain.calendarEvent).forPatientIdentifier(patientIdentifier).forScopeFilter(scopeFilter).build();
		ResponseMessage responseMessage = router.execute(request);
		return PatientDataResponseReader.<CalendarEvents, CalendarEvent> fromResponse(responseMessage).getDataListNoNull(CalendarEvents.class);
	}

	public CalendarEvent saveCalendarEvent(CalendarEvent calendarEvent, ScopeFilter scopeFilter) {
		RequestMessage request = PatientDataEditRequestBuilder.forUpdate().forDomain(Domain.calendarEvent).forScope(scopeFilter).forData(calendarEvent).build();
		ResponseMessage responseMessage = router.execute(request);
		return PatientDataResponseReader.<CalendarEvents, CalendarEvent> fromResponse(responseMessage).getDataItem();
	}
}
