package com.agilex.healthcare.mobilehealthplatform.datalayer.calendar;

import net.fortuna.ical4j.model.Calendar;

import com.agilex.healthcare.mobilehealthplatform.datalayer.appointment.AppointmentDataService;
import com.agilex.healthcare.mobilehealthplatform.domain.Appointments;
import com.agilex.healthcare.mobilehealthplatform.domain.CalendarEvents;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.ical.ICalEventHelper;
import com.agilex.healthcare.mobilehealthplatform.ical.ICalHelper;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;

public class CalendarDataService {

	AppointmentDataService appointmentDataService;
	CalendarEventDataService calendarEventDataService;

	public CalendarDataService() {
		appointmentDataService = new AppointmentDataService();
		calendarEventDataService = new CalendarEventDataService();
	}
	
	public String getAggregatedPatientCalendar(PatientIdentifier patientIdentifier, DateFilter dateFilter) {
		Appointments appointments = appointmentDataService.getPatientAppointments(patientIdentifier, dateFilter);
		Calendar appointmentsCalendar = ICalHelper.transformAppointmentsToIcal(appointments);
		
		CalendarEvents calendarEvents = calendarEventDataService.getCalendarEvents(patientIdentifier, ScopeFilter.getInstanceForLongitudinalScope());
		Calendar aggregatedCalendar = ICalEventHelper.transformCalendarEventToICal(appointmentsCalendar, calendarEvents);
		
		return aggregatedCalendar.toString();
	}
}
