package com.agilex.healthcare.mobilehealthplatform.datalayer.audit;

import com.agilex.healthcare.mobilehealthplatform.domain.AuditLog;
import com.agilex.healthcare.mobilehealthplatform.domain.AuditLogs;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ServiceRegistry;

public class AuditLogDataService {
	private AuditLogDataLayer datalayer;
	
	public AuditLogDataService() {
		datalayer = ServiceRegistry.getInstance().getPrimaryCommunity().getDataLayerFactory().getAuditLogDataLayer();
	}
	
	public AuditLogs fetchAuditLogs(String userId, AuditLogFilter filter) {
		return datalayer.fetchAuditLogs(userId, filter);
	}
	
	public AuditLog fetchAuditLog(String userId, String auditLogId) {
		return datalayer.fetchAuditLog(userId, auditLogId);
	}

	public AuditLog saveAudit(AuditLog auditLog) {
		return datalayer.saveAudit(auditLog);
	}
}
