package com.agilex.healthcare.mobilehealthplatform.datalayer.assessmentresults.reports;

import com.agilex.healthcare.mobilehealthplatform.domain.PainDiaryEntries;
import com.agilex.healthcare.mobilehealthplatform.domain.PainDiaryEntry;

import java.util.Collections;

abstract class RecentFieldListItemsBuilderBase implements RecentFieldListItemBuilder.RecentFieldListItemsBuilder {
    private final int MaxDiaryEntriesForRecent = 7;

    PainDiaryEntries entries;

    RecentFieldListItemsBuilderBase(PainDiaryEntries entries){
        this.entries = entries;
    }

    public String build(){
        return determineCommonList(entries);
    }

    abstract String getEntryItemText(PainDiaryEntry entry);

    private String determineCommonList(PainDiaryEntries painDiaryEntries) {
        String activators = HtmlReportBuilder.create("").build();

        if (painDiaryEntries.size() > 0){
            //Only use activators in most recent entry
            Collections.sort(painDiaryEntries, new ReverseComparator(new PainDiaryDateComparator()));

            int maxEntriesIndex = MaxDiaryEntriesForRecent;          //default to last 7 entries
            if (painDiaryEntries.size() < MaxDiaryEntriesForRecent){
                maxEntriesIndex = painDiaryEntries.size();
            }
            for(int i = 0; i < maxEntriesIndex; i++){
                PainDiaryEntry entry = painDiaryEntries.get(i);
                String itemText = getEntryItemText(entry);
                if (itemText != null){
                    activators += HtmlReportBuilder.create(itemText).listItem().build();
                }
            }
        }
        return activators;
    }

}
