package com.agilex.healthcare.mobilehealthplatform.datalayer.assessmentresults.reports;

import com.agilex.healthcare.mobilehealthplatform.domain.AssessmentResults;
import com.agilex.healthcare.mobilehealthplatform.domain.PainDiaryEntries;
import com.agilex.healthcare.mobilehealthplatform.domain.PainGoals;
import com.agilex.healthcare.mobilehealthplatform.domain.ToolTrackingResults;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;

import java.util.Date;

public class PainConsolidatedReportGeneratorParameter {
    private final Patient patient;
    private final Date startDate;
    private final Date endDate;
    private final AssessmentResults assessmentResults;
    private final PainDiaryEntries painDiaryEntries;
    private final PainGoals painGoals;
    private final ToolTrackingResults toolTrackingResults;

    public PainConsolidatedReportGeneratorParameter(Patient patient, Date startdate, Date endDate, AssessmentResults assessmentResults, PainDiaryEntries painDiaryEntries, PainGoals painGoals, ToolTrackingResults toolTrackingResults) {
        this.patient = patient;
        this.startDate = startdate;
        this.endDate = endDate;
        this.assessmentResults = assessmentResults;
        this.painDiaryEntries = painDiaryEntries;
        this.painGoals = painGoals;
        this.toolTrackingResults = toolTrackingResults;
    }

    public AssessmentResults getAssessmentResults() {
        return assessmentResults;
    }

    public PainDiaryEntries getPainDiaryEntries() {
        return painDiaryEntries;
    }

    public PainGoals getPainGoals() {
        return painGoals;
    }

    public ToolTrackingResults getToolTrackingResults() {
        return toolTrackingResults;
    }

    public Patient getPatient() {
        return patient;
    }

    public Date getStartDate() {
        return startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

}
