package com.agilex.healthcare.mobilehealthplatform.datalayer.assessmentresults.reports;

//Simplify html generation by using a builder approach to common html elements
public class HtmlReportBuilder {
    String report = "";

    public HtmlReportBuilder(String report){
        this.report = report;
    }

    public static HtmlReportBuilder create(String value){
        return new HtmlReportBuilder(value);
    }

    public HtmlReportBuilder progressBar(int progress){
        String table;
        String progressCellComplete = "";
        String progressCellIncomplete = "";
        String tableBegin = "<table><tr><td>" +
                "<table width='250px' height='15px' style='border: solid black 1px' cellspacing='0'>\n" +
                "    <tr>\n";

        //if progress is zero, need to hide entire cell, otherwise, html does not render properly
        if (progress != 0){
            progressCellComplete = String.format(
                "        <td width='%1s%%' bgcolor='gray'></td>\n", progress);
        }

        //if progress is 100, need to hide entire cell, otherwise, displays narrow incomplete sliver
        if (progress != 100){
            progressCellIncomplete= String.format(
                    "        <td bgcolor='white'></td>\n", progress);
        }

        String tableEnd =
                "    </tr>\n" +
                "</table>";

        this.report += tableBegin + progressCellComplete + progressCellIncomplete + tableEnd +
                "</td><td>" + String.format("&nbsp;&nbsp;&nbsp;%1s%%", progress) + "</td></tr></table>\n";
        return this;
    }
    public HtmlReportBuilder bold(){
        this.report = "<b>" + this.report + "</b>";
        return this;
    }

    public HtmlReportBuilder center(){
        this.report = "<center>" + this.report + "</center>";
        return this;
    }
    public HtmlReportBuilder underline(){
        this.report = "<u>" + this.report + "</u>";
        return this;
    }

    public HtmlReportBuilder nl(){
        this.report += "<br/>\n";
        return this;
    }


    @Override
    public String toString(){
        return build();
    }

    public String build(){
        return this.report;
    }

    public HtmlReportBuilder listItem() {
        this.report = "<li>" + this.report + "</li>";
        return this;
    }

    public HtmlReportBuilder unorderedList() {
        this.report = "<ul>" + this.report + "</ul>";
        return this;
    }
}
