package com.agilex.healthcare.mobilehealthplatform.datalayer.assessmentresults;

import java.util.Collections;
import java.util.HashMap;

import com.agilex.healthcare.mobilehealthplatform.domain.ToolCategories;
import com.agilex.healthcare.mobilehealthplatform.domain.ToolCategory;

public class ZaritToolCalculator {
	public static final ToolCategory RELAX = new ToolCategory("Relax Yourself");
	public static final ToolCategory CHANGE = new ToolCategory("Change Perspective");
	public static final ToolCategory DISTRACT = new ToolCategory("Distract Yourself");
	public static final ToolCategory PLAN = new ToolCategory("Plan a Social Activity");
	public static final ToolCategory TIME_OUT = new ToolCategory("Take a Time Out");
	public static final ToolCategory PLEASANT = new ToolCategory("Pleasant Events");
	public static final ToolCategory SOOTHE = new ToolCategory("Soothe Yourself");
	public static final ToolCategory QUOTES = new ToolCategory("Inspiring Quotes");
	public static final ToolCategory SUPPORT = new ToolCategory("Visit the Support section of the App");

	private HashMap<Integer, ToolCategories> toolMap = new HashMap<Integer, ToolCategories>();

	public ZaritToolCalculator() {
		initToolMap();
	}

	private void initToolMap() {
		initToolsForQuestionNumber(1, new ToolCategory[] { RELAX, PLAN, PLEASANT, SOOTHE, SUPPORT });
		initToolsForQuestionNumber(2, new ToolCategory[] { RELAX, SUPPORT });
		initToolsForQuestionNumber(3, new ToolCategory[] { RELAX, CHANGE, DISTRACT, TIME_OUT, SOOTHE, SUPPORT });
		initToolsForQuestionNumber(4, new ToolCategory[] { RELAX, CHANGE, PLAN, PLEASANT, SUPPORT });
		initToolsForQuestionNumber(5, new ToolCategory[] { RELAX, CHANGE, DISTRACT, TIME_OUT, PLEASANT, SOOTHE, SUPPORT });
		initToolsForQuestionNumber(6, new ToolCategory[] { RELAX, TIME_OUT, PLEASANT, SOOTHE, SUPPORT });
		initToolsForQuestionNumber(7, new ToolCategory[] { RELAX, PLAN, PLEASANT, SUPPORT });
		initToolsForQuestionNumber(8, new ToolCategory[] { PLAN, PLEASANT, SUPPORT });
		initToolsForQuestionNumber(9, new ToolCategory[] { RELAX, CHANGE, TIME_OUT, PLEASANT, SOOTHE, SUPPORT });
		initToolsForQuestionNumber(10, new ToolCategory[] { CHANGE, SUPPORT });
		initToolsForQuestionNumber(11, new ToolCategory[] { RELAX, CHANGE, TIME_OUT, SUPPORT });
		initToolsForQuestionNumber(12, new ToolCategory[] { RELAX, CHANGE, SUPPORT });
	}

	private void initToolsForQuestionNumber(int i, ToolCategory[] toolCategories) {
		Integer key = new Integer(i);
		ToolCategories categoriesToAdd = new ToolCategories();
		for (ToolCategory toolCategory : toolCategories) {
			categoriesToAdd.add(toolCategory);
		}
		toolMap.put(key, categoriesToAdd);
	}

	public ToolCategories getRecommendedToolCategories(int[] questionNumbersOverCutoff) {
		ToolCategories allRecommendedToolCategories = getAllRecommendedTools(questionNumbersOverCutoff);
		ToolCategories toolsWithoutDuplicates = countAndRemoveDuplicates(allRecommendedToolCategories);
		Collections.sort(toolsWithoutDuplicates);
		return toolsWithoutDuplicates;
	}

	private ToolCategories getAllRecommendedTools(int[] questionNumbersOverCutoff) {
		ToolCategories allRecommendedToolCategories = new ToolCategories();
		for (int i = 0; i < questionNumbersOverCutoff.length; i++) {
			int questionNumber = questionNumbersOverCutoff[i];
			ToolCategories toolsForQuestion = toolMap.get(new Integer(questionNumber));
			if (toolsForQuestion != null) {
				allRecommendedToolCategories.addAll(toolsForQuestion);
			}
		}
		return allRecommendedToolCategories;
	}

	private ToolCategories countAndRemoveDuplicates(ToolCategories allRecommendedToolCategories) {
		ToolCategories listWithoutDuplicates = new ToolCategories();
		for (ToolCategory toolCategory : allRecommendedToolCategories) {
			if (listWithoutDuplicates.containsTool(toolCategory)) {
				ToolCategory duplicatedCategory = listWithoutDuplicates.getToolCategoryByName(toolCategory.getName());
				duplicatedCategory.increaseRecommendationCount();
				listWithoutDuplicates.remove(toolCategory);
				listWithoutDuplicates.add(duplicatedCategory);
			} else {
				toolCategory.setRecommendationCount(1);
				listWithoutDuplicates.add(toolCategory);
			}
		}
		return listWithoutDuplicates;
	}

}
