package com.agilex.healthcare.mobilehealthplatform.datalayer.assessmentresults;

import com.agilex.healthcare.mobilehealthplatform.domain.AssessmentProperties;
import com.agilex.healthcare.mobilehealthplatform.domain.AssessmentQuestionChoice;
import com.agilex.healthcare.mobilehealthplatform.domain.AssessmentQuestionChoices;
import com.agilex.healthcare.mobilehealthplatform.domain.AssessmentResponse;
import com.agilex.healthcare.mobilehealthplatform.domain.AssessmentResponses;
import com.agilex.healthcare.mobilehealthplatform.domain.AssessmentResult;
import com.agilex.healthcare.mobilehealthplatform.domain.code.AssessmentCode;

public class SummationScorer implements ResultScorer {
	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(SummationScorer.class);

	@Override
	public int calculateScore(AssessmentResult assessmentResult) {
		logger.debug("calculating score of responses");
		int totalScore = 0;
		AssessmentResponses allResponses = assessmentResult.getResponses();
		for (AssessmentResponse assessmentResponse : allResponses) {
			int responseScore = calculateResponsePointValue(assessmentResponse);
			totalScore += responseScore;
			logger.debug(String.format("calculating score [response=%s][score=%s]", responseScore, totalScore));
		}
		return totalScore;
	}
	
	public int calculateResponsePointValue(AssessmentResponse assessmentResponse) {
		int responseScore;
		try {
			AssessmentQuestionChoices selectedChoices = assessmentResponse.getSelectedChoices();
			AssessmentQuestionChoice firstSelectedChoice = selectedChoices.get(0);
			AssessmentProperties properties = firstSelectedChoice.getProperties();
			String responseScoreAsString = properties.getValueByPropertyName(AssessmentCode.RESULT_PROPERTY_POINT_VALUE);
			responseScore = Integer.parseInt(responseScoreAsString);
			logger.debug("setting response score");
		} catch (Exception e) {
			logger.debug("Could not find response point value. Setting response score of 0");
			responseScore = 0;
		}
		return responseScore;
	}

}
