package com.agilex.healthcare.mobilehealthplatform.datalayer.assessmentresults;

import com.agilex.healthcare.mobilehealthplatform.domain.AssessmentResult;
import com.agilex.healthcare.mobilehealthplatform.domain.code.AssessmentCode;
import com.agilex.healthcare.utility.NullSafeStringComparer;

public class ResultScorerFactory {
	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(ResultScorerFactory.class);

	public static ResultScorer getScorer(AssessmentResult assessmentResultToScore) {
		ResultScorer scorer;
		if (assessmentResultToScore.isInProgress()) {
			scorer = new NoOperationScorer();
		} else if (NullSafeStringComparer.areEqual(assessmentResultToScore.getScoringAlgorithm(), AssessmentCode.SCORING_ALGORITHM_ZARIT)) {
			scorer = new SummationScorer();
		} else if (NullSafeStringComparer.areEqual(assessmentResultToScore.getScoringAlgorithm(), AssessmentCode.SCORING_ALGORITHM_PTSD)) {
			scorer = new SummationScorer();
		} else {
			scorer = new NoOperationScorer();
		}
		logger.debug("determine scorer based on assessment");
		
		return scorer;
	}
}