package com.agilex.healthcare.mobilehealthplatform.datalayer.assessmentresults;

import com.agilex.healthcare.mobilehealthplatform.domain.AssessmentResult;
import com.agilex.healthcare.mobilehealthplatform.domain.code.AssessmentCode;
import com.agilex.healthcare.utility.NullSafeStringComparer;

public class ReportGeneratorFactory {
	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(ReportGeneratorFactory.class);

	public static ReportGenerator getReportGenerator(AssessmentResult assessmentResult) {
		ReportGenerator reportGenerator;
		if (assessmentResult.isInProgress()) {
			reportGenerator = new NoOperationReportGenerator();
		} else if (NullSafeStringComparer.areEqual(assessmentResult.getScoringAlgorithm(), AssessmentCode.SCORING_ALGORITHM_ZARIT)) {
			reportGenerator = new ZaritReportGenerator();
		} else if (NullSafeStringComparer.areEqual(assessmentResult.getScoringAlgorithm(), AssessmentCode.SCORING_ALGORITHM_PTSD)) {
			reportGenerator = new PTSDReportGenerator();
		}
		else if ("monthlyPain".equals(assessmentResult.getAssessmentId())){
			reportGenerator = new MonthlyPainReportGenerator();
		}
		else {
			reportGenerator = new NoOperationReportGenerator();
		}
		logger.debug("determine result generator based on assessment");
		return reportGenerator;
	}
}