package com.agilex.healthcare.mobilehealthplatform.datalayer.assessmentresults;

import java.util.Collections;
import java.util.HashMap;

import com.agilex.healthcare.mobilehealthplatform.domain.ToolCategories;
import com.agilex.healthcare.mobilehealthplatform.domain.ToolCategory;

public class PTSDToolCalculator {
	public static final ToolCategory VISUALIZATION = new ToolCategory("Visualization"); 
	public static final ToolCategory RID = new ToolCategory("RID");
	public static final ToolCategory PLEASANT = new ToolCategory("Pleasant Events");
	public static final ToolCategory PERSPECTIVE = new ToolCategory("Change Perspective"); 
	public static final ToolCategory QUOTES = new ToolCategory("Inspiring Quotes");
	public static final ToolCategory GROUNDING = new ToolCategory("Grounding");
	public static final ToolCategory TIME_OUT = new ToolCategory("Take a Time Out");
	public static final ToolCategory SUPPORT = new ToolCategory("Support");
	public static final ToolCategory SLEEP_TIPS = new ToolCategory("Sleep Tips");
	public static final ToolCategory DISTRACT = new ToolCategory("Distract Yourself");
	public static final ToolCategory ISOLATION = new ToolCategory("Reduce Isolation");

	private HashMap<Integer, ToolCategories> toolMap = new HashMap<Integer, ToolCategories>();

	public PTSDToolCalculator() {
		initToolMap();
	}

	private void initToolMap() {
		initToolsForQuestionNumber(1, new ToolCategory[] { VISUALIZATION, PERSPECTIVE, GROUNDING, SUPPORT, ISOLATION });
		initToolsForQuestionNumber(2, new ToolCategory[] { VISUALIZATION, PERSPECTIVE, GROUNDING, SUPPORT, SLEEP_TIPS, ISOLATION });
		initToolsForQuestionNumber(3, new ToolCategory[] { VISUALIZATION, PERSPECTIVE, GROUNDING, SUPPORT, ISOLATION });
		initToolsForQuestionNumber(4, new ToolCategory[] { VISUALIZATION, RID, PERSPECTIVE, GROUNDING, TIME_OUT, SUPPORT, DISTRACT });
		initToolsForQuestionNumber(5, new ToolCategory[] { VISUALIZATION, RID, PERSPECTIVE, GROUNDING, TIME_OUT, SUPPORT, DISTRACT });
		initToolsForQuestionNumber(6, new ToolCategory[] { PLEASANT, PERSPECTIVE, SUPPORT, ISOLATION });
		initToolsForQuestionNumber(7, new ToolCategory[] { PLEASANT, PERSPECTIVE, SUPPORT, ISOLATION });
		initToolsForQuestionNumber(8, new ToolCategory[] { PERSPECTIVE, SUPPORT });
		initToolsForQuestionNumber(9, new ToolCategory[] { PLEASANT, SUPPORT, ISOLATION });
		initToolsForQuestionNumber(10, new ToolCategory[] { PLEASANT, SUPPORT, ISOLATION });
		initToolsForQuestionNumber(11, new ToolCategory[] { PLEASANT, SUPPORT, ISOLATION });
		initToolsForQuestionNumber(12, new ToolCategory[] { VISUALIZATION, PLEASANT, SUPPORT, ISOLATION });
		initToolsForQuestionNumber(13, new ToolCategory[] { VISUALIZATION, PLEASANT, PERSPECTIVE, SLEEP_TIPS });
		initToolsForQuestionNumber(14, new ToolCategory[] { VISUALIZATION, PLEASANT, PERSPECTIVE, GROUNDING, TIME_OUT, DISTRACT });
		initToolsForQuestionNumber(15, new ToolCategory[] { VISUALIZATION, PERSPECTIVE, GROUNDING, SUPPORT });
		initToolsForQuestionNumber(16, new ToolCategory[] { VISUALIZATION, GROUNDING, SUPPORT, DISTRACT });
		initToolsForQuestionNumber(17, new ToolCategory[] { VISUALIZATION, GROUNDING, SUPPORT, DISTRACT });
	}

	private void initToolsForQuestionNumber(int i, ToolCategory[] toolCategories) {
		Integer key = new Integer(i);
		ToolCategories categoriesToAdd = new ToolCategories();
		for (ToolCategory toolCategory : toolCategories) {
			categoriesToAdd.add(toolCategory);
		}
		toolMap.put(key, categoriesToAdd);
	}

	public ToolCategories getRecommendedToolCategories(int[] questionNumbersOverCutoff) {
		ToolCategories allRecommendedToolCategories = getAllRecommendedTools(questionNumbersOverCutoff);
		ToolCategories toolsWithoutDuplicates = countAndRemoveDuplicates(allRecommendedToolCategories);
		Collections.sort(toolsWithoutDuplicates);
		return toolsWithoutDuplicates;
	}

	private ToolCategories getAllRecommendedTools(int[] questionNumbersOverCutoff) {
		ToolCategories allRecommendedToolCategories = new ToolCategories();
		for (int i = 0; i < questionNumbersOverCutoff.length; i++) {
			int questionNumber = questionNumbersOverCutoff[i];
			ToolCategories toolsForQuestion = toolMap.get(new Integer(questionNumber));
			if (toolsForQuestion != null) {
				allRecommendedToolCategories.addAll(toolsForQuestion);
			}
		}
		return allRecommendedToolCategories;
	}

	private ToolCategories countAndRemoveDuplicates(ToolCategories allRecommendedToolCategories) {
		ToolCategories listWithoutDuplicates = new ToolCategories();
		for (ToolCategory toolCategory : allRecommendedToolCategories) {
			if (listWithoutDuplicates.containsTool(toolCategory)) {
				ToolCategory duplicatedCategory = listWithoutDuplicates.getToolCategoryByName(toolCategory.getName());
				duplicatedCategory.increaseRecommendationCount();
				listWithoutDuplicates.remove(toolCategory);
				listWithoutDuplicates.add(duplicatedCategory);
			} else {
				toolCategory.setRecommendationCount(1);
				listWithoutDuplicates.add(toolCategory);
			}
		}
		return listWithoutDuplicates;
	}
}
