package com.agilex.healthcare.mobilehealthplatform.datalayer.assessmentresults;

public class PTSDReportSettings {
	public final int cuttoffResponseScore = 3;
	public final int maxScore = 85;
	public final int lowestScoreCutoff = 17;
	public final int mediumScoreCutoff = 49;
	public final int lowScoreCutoff = 34;
	public final String noPreviousResultText = "You have no previous assessment for comparison.\n\n";
	public final String sameScoreText = "Your score has not changed since the last time you took this self-assessment.\n\n";
	public final String increasedScoreText = "Your score went up since the last time you took this self-assessment.\n\n";
	public final String decreasedScoreText = "Good news: Your score has improved since the last time you took this self-assessment.\n\n";
	public final String lowestScoreText = "You are not reporting any symptoms of Posttraumatic Stress Disorder at this time. However, this assessment will not pick up other problems that can be related to trauma such as depression, substance abuse, and anxiety.\n\n";
	public final String lowScoreText = "You are reporting some difficulties related to your traumatic experience, but these problems most likely would not be given a diagnosis of Posttraumatic Stress Disorder. However, you may still be struggling. Even mild posttraumatic stress can be distressing enough to interrupt your life. Plus, problems like depression, substance abuse, and anxiety can also happen after a trauma and may not register on a PTSD scale.\n\n";
	public final String mediumScoreText = "You are reporting a number of symptoms related to your traumatic experience. Reactions like yours are normal. Many people who experience a trauma have this kind of reaction, at least for the first few weeks or months after the trauma.\n\nPeople who have symptoms like yours can often benefit from talking to a healthcare provider. You might want to consider contacting your mental health treatment provider. Seeking help will be especially important if you think that you may have other trauma-related problems that this assessment would not identify, such as depression, substance abuse, or anxiety.\n\n";
	public final String highScoreText = "Your score puts you in the high range, which means that you are reporting a lot of PTSD symptoms.\n\nReactions like yours are normal. Many people who experience a trauma have this kind of reaction, at least for the first few weeks or months after the trauma. But once the problems have gone on for a while or they start to make it hard to function at home, school, or work, it's time to ask for some help.  Symptoms like these may not change much without fully engaging in treatment with a professional.\n\nSeeking help will be especially important if you think that you may have other trauma-related problems that this assessment would not identify, such as depression, substance abuse, or anxiety.\n\n";
	public final String highScoreAndNotScheduledToSeeProviderText = "There are scientifically proven treatments that really work for PTSD. Don't suffer for any longer than you have to.\n\n";
	public final String scheduledToSeeProviderText = "Make sure you discuss your results at your next mental health treatment appointment. Your provider may recommend that you re-take this assessment on a regular basis to see how your symptoms are changing over time.  Also speak with your provider about how you can make the best use of the stress management strategies on this app.\n\n";
	public final String notScheduledToSeeProviderText = "If you are feeling stressed, consider making an appointment with a healthcare provider, regardless of the outcome of this assessment.  A professional will be able to help you understand what is going on and what you can do to deal with stress. For information on where to find a healthcare provider, check out the Find Support section of this app.  You can also learn more about professional care in the Learn section of this app.\n\n";
	public final String endOfAllResultsText = "While there is no substitute for professional face-to-face care, this app can help you learn effective strategies for managing your stress on a day-to-day basis. Take some time to explore the many tools on this app.\n\nYou may want to use the reminder section in this app to set a reminder to take the assessment monthly, unless a healthcare provider has recommended that you take it more frequently.\n\nIf you ever feel like hurting yourself or someone else, check out the Find Support section of this app to get help right away.";
	public final String highScoringQuestionsExplanation = "Based upon your current assessment, it is recommended that you try the tools listed below. The tools can be easily found from the Tools button on the What's Wrong page of this app.";
	
	public PTSDReportSettings() {
	}
}
