package com.agilex.healthcare.mobilehealthplatform.datalayer.assessmentresults;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.AbstractFetchPatientDataListRequestHandler;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataFetchRequestReader;
import com.agilex.healthcare.mobilehealthplatform.domain.AssessmentResult;
import com.agilex.healthcare.mobilehealthplatform.domain.AssessmentResults;

public class FetchMostRecentAssessmentResultRequestHandler extends AbstractFetchPatientDataListRequestHandler<AssessmentResultDataLayer, AssessmentResults, AssessmentResult> {

	@Override
	protected AssessmentResults invokeDataLayerToFetchList(AssessmentResultDataLayer datalayer, RequestMessage requestMessage, PatientDataFetchRequestReader messageReader) {
		AssessmentResults assessmentResults = new AssessmentResults();

		AssessmentResult mostRecentAssessmentResult = datalayer.fetchMostRecentlyCompletedResult(requestMessage.getValueAsString("assessment-id"), messageReader.getPatientIdentifier());
		if (mostRecentAssessmentResult != null) {
			assessmentResults.add(mostRecentAssessmentResult);
		}
		return assessmentResults;
	}

}
