package com.agilex.healthcare.mobilehealthplatform.datalayer.assessmentresults;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.AbstractFetchPatientDataListRequestHandler;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataFetchRequestReader;
import com.agilex.healthcare.mobilehealthplatform.domain.AssessmentResult;
import com.agilex.healthcare.mobilehealthplatform.domain.AssessmentResults;

public class FetchAssessmentResultListRequestHandler extends AbstractFetchPatientDataListRequestHandler<AssessmentResultDataLayer, AssessmentResults, AssessmentResult> {

	@Override
	protected AssessmentResults invokeDataLayerToFetchList(AssessmentResultDataLayer datalayer, RequestMessage requestMessage, PatientDataFetchRequestReader messageReader) {
		return datalayer.fetchResultsByAssessment(messageReader.getPatientIdentifier(), requestMessage.getValueAsString("assessment-id"), messageReader.getDateFilter());
	}

}
