package com.agilex.healthcare.mobilehealthplatform.datalayer.assessment;

import com.agilex.healthcare.mobilehealthplatform.datalayer.assessmentresults.AssessmentResultsDataService;
import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.*;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.*;

public class AssessmentDataService {
	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(AssessmentDataService.class);
	private AssessmentDataLayer datalayer;

	public AssessmentDataService() {
		datalayer = ServiceRegistry.getInstance().getPrimaryCommunity().getDataLayerFactory().getAssessmentDataLayer();
	}

	public Assessments fetchActiveAssessments() {
		return datalayer.fetchActiveAssessments();
	}

	public Assessment fetchAssessment(String assessmentId) {
		logger.debug("fetchAssessmentß");
		return datalayer.fetchAssessment(assessmentId);
	}

	// Utilize patient results to potentially modify the returned assessment as
	// needed (currently only Monthly Pain assessment)
	public Assessment fetchAssessment(String assessmentId, PatientIdentifier patientIdentifier) {
		logger.debug("fetchAssessment containing patient identifier");
		Assessment assessment = datalayer.fetchAssessment(assessmentId);

		logger.debug("assessment retrieved");
		if (assessment != null) {
			logger.debug("assessment not null");
			if (assessmentId.contentEquals("monthlyPain")) {
				logger.debug("assessment Id equals monthlyPain");

				DateFilter dateFilter = DateFilterFactory.createEmptyFilter();
				ScopeFilter scopeFilter = ScopeFilter.getInstanceForLongitudinalScope();
				AssessmentResultsDataService dataservice = new AssessmentResultsDataService();
				logger.debug("fetching assessmentResults");
				AssessmentResults assessmentResults = dataservice.fetchResultsByAssessment(patientIdentifier, "monthlyPain", dateFilter, scopeFilter);
				logger.debug("assessmentResults retrieved, assessmentResults.size() = " + assessmentResults.size());

				if (assessmentResults.size() == 0) {
					logger.debug("assessmentResults.size() = 0");
					// get the question
					AssessmentQuestion question = assessment.getQuestionById("Q13");
					assessment.getQuestions().remove(question);
					logger.debug("question13 removed");
				}
			}
		}
		logger.debug("returning assessment");
		return assessment;

	}

	public AssessmentQuestion fetchQuestion(String assessmentId, String questionId) {
		return datalayer.fetchQuestion(assessmentId, questionId);
	}

	public Assessments fetchAssessmentsForHealthAssessment() {
		return datalayer.fetchAssessmentsForHealthAssessment();
	}
}
