package com.agilex.healthcare.mobilehealthplatform.datalayer.appointment;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.domain.DataIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;
import com.agilex.healthcare.utility.NullChecker;

public class UpdateProviderSeenAppointmentRequestFlagRequestBuilder {
	protected RequestMessage request;

	protected UpdateProviderSeenAppointmentRequestFlagRequestBuilder(RequestMessage request) {
		this.request = request;
	}

	public static UpdateProviderSeenAppointmentRequestFlagRequestBuilder forUpdateProviderSeenAppointmentRequestFlag(){
    	RequestMessage request = new RequestMessage();
    	UpdateProviderSeenAppointmentRequestFlagRequestBuilder builder = new UpdateProviderSeenAppointmentRequestFlagRequestBuilder(request);
    	request.setType("AppointmentRequestSeenByProvider");
    	return builder;
    }
	
	public  UpdateProviderSeenAppointmentRequestFlagRequestBuilder forDomain(String domain) {
		request.setValue("domain", domain);
		return this;
	}
	
	public UpdateProviderSeenAppointmentRequestFlagRequestBuilder forAppointmentRequestId(String appointmentRequestId) {
		request.setValue("appointment-request-id", appointmentRequestId);
		return this;
	}
	
	public UpdateProviderSeenAppointmentRequestFlagRequestBuilder forScopeFilter(ScopeFilter scopeFilter) {
		request.setValue("scope-filter", scopeFilter);
		return this;
	}

    public  UpdateProviderSeenAppointmentRequestFlagRequestBuilder forPatientIdentifier(PatientIdentifier patientIdentifier) {
        request.setValue("patient-identifier", patientIdentifier);
        return this;
    }

    public  UpdateProviderSeenAppointmentRequestFlagRequestBuilder forDataIdentifier(DataIdentifier dataIdentifier) {
        request.setValue("data-identifier", dataIdentifier);
        return this;
    }
	
	public RequestMessage build(){
		if (NullChecker.isNullish(request.getMessageId()))
			throw new IllegalArgumentException("ID is a required field");
		if (NullChecker.isNullish(request.getType()))
			throw new IllegalArgumentException("Type is a required field");
		return request;
	}
}
