package com.agilex.healthcare.mobilehealthplatform.datalayer.appointment;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.domain.DataIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;
import com.agilex.healthcare.utility.NullChecker;

public class UpdateAppointmentRequestMessageFlagRequestBuilder {
	protected RequestMessage request;

	protected UpdateAppointmentRequestMessageFlagRequestBuilder(RequestMessage request) {
		this.request = request;
	}

	public static UpdateAppointmentRequestMessageFlagRequestBuilder forUpdateMessageFlag() {
		RequestMessage request = new RequestMessage();
		UpdateAppointmentRequestMessageFlagRequestBuilder builder = new UpdateAppointmentRequestMessageFlagRequestBuilder(request);
		request.setType("AppointmentRequestUpdateMessageFlag");
		return builder;
	}
	
	public  UpdateAppointmentRequestMessageFlagRequestBuilder forDomain(String domain) {
		request.setValue("domain", domain);
		return this;
	}

    public  UpdateAppointmentRequestMessageFlagRequestBuilder forPatientIdentifier(PatientIdentifier patientIdentifier) {
        request.setValue("patient-identifier", patientIdentifier);
        return this;
    }

    public  UpdateAppointmentRequestMessageFlagRequestBuilder forDataIdentifier(DataIdentifier dataIdentifier) {
        request.setValue("data-identifier", dataIdentifier);
        return this;
    }

	public UpdateAppointmentRequestMessageFlagRequestBuilder forAppointmentRequestId(String appointmentRequestId) {
		request.setValue("appointment-request-id", appointmentRequestId);
		return this;
	}

	public UpdateAppointmentRequestMessageFlagRequestBuilder forScopeFilter(ScopeFilter scopeFilter) {
		request.setValue("scope-filter", scopeFilter);
		return this;
	}

	public RequestMessage build(){
		if (NullChecker.isNullish(request.getMessageId()))
			throw new IllegalArgumentException("ID is a required field");
		if (NullChecker.isNullish(request.getType()))
			throw new IllegalArgumentException("Type is a required field");
		return request;
	}
}
