package com.agilex.healthcare.mobilehealthplatform.datalayer.appointment;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestHandler;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.ResponseMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataResponseBuilder;
import com.agilex.healthcare.mobilehealthplatform.domain.AppointmentRequest;
import com.agilex.healthcare.mobilehealthplatform.security.MhpUserFactory;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.DomainServiceRegistry;

public class UpdateAppointmentRequestMessageFlagHandler implements RequestHandler {
	
	@Override
	public ResponseMessage handle(RequestMessage requestMessage) {
		AppointmentRequestDataLayer datalayer = getDataLayer(requestMessage);
		UpdateAppointmentRequestMessageFlagRequestReader messageReader = UpdateAppointmentRequestMessageFlagRequestReader.fromRequest(requestMessage);
		boolean isProvider = MhpUserFactory.doesUserHasStaffRole();
		AppointmentRequest appointmentRequest = datalayer.updateMessageFlag(messageReader.getPatientIdentifier().getUniqueId(), messageReader.getAppointmentRequestId(), isProvider);		
        MhpUserFactory.addSurrogateToPatientData(appointmentRequest);
		return PatientDataResponseBuilder.fromPatientData(appointmentRequest).build();
	}

	private AppointmentRequestDataLayer getDataLayer(RequestMessage requestMessage) {
		DomainServiceRegistry serviceRegistry = new DomainServiceRegistry();
		return serviceRegistry.getDataLayerByMessage(requestMessage);
	}
}
