package com.agilex.healthcare.mobilehealthplatform.datalayer.appointment;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.AbstractSavePatientDataRequestHandler;
import com.agilex.healthcare.mobilehealthplatform.domain.AppointmentRequestMessage;
import com.agilex.healthcare.mobilehealthplatform.security.MhpUserFactory;

/**
 * Created with IntelliJ IDEA.
 * User: clarkee
 * Date: 1/25/13
 * Time: 3:54 PM
 * To change this template use File | Settings | File Templates.
 */
public class SaveAppointmentRequestMessageHandler extends AbstractSavePatientDataRequestHandler<AppointmentRequestDataLayer, AppointmentRequestMessage> {
    @Override
    protected AppointmentRequestMessage invokeDataLayerToSaveItem(AppointmentRequestDataLayer datalayer, AppointmentRequestMessage data, RequestMessage requestMessage) {
    	boolean isProvider = MhpUserFactory.doesUserHasStaffRole();
        return datalayer.saveAppointmentRequestMessage(data.getPatientId(), data, isProvider);
    }
}
