package com.agilex.healthcare.mobilehealthplatform.datalayer.appointment;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.*;
import com.agilex.healthcare.mobilehealthplatform.domain.*;

public class FetchMentalHealthAppointmentListRequestHandler extends AbstractFetchPatientDataListRequestHandler<MentalHealthAppointmentDataLayer, Appointments, Appointment> {

	@Override
	protected Appointments invokeDataLayerToFetchList(MentalHealthAppointmentDataLayer datalayer, RequestMessage requestMessage, PatientDataFetchRequestReader messageReader) {
		Appointments mentalHealthAppointments = datalayer.fetchMentalHealthAppointments(messageReader.getPatientIdentifier(), messageReader.getDateFilter());
		return mentalHealthAppointments;
	}

}
