package com.agilex.healthcare.mobilehealthplatform.datalayer.appointment;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.AbstractFetchPatientDataRequestHandler;
import com.agilex.healthcare.mobilehealthplatform.domain.*;

public class FetchAppointmentRequestRequestHandler extends AbstractFetchPatientDataRequestHandler<AppointmentRequestDataLayer, AppointmentRequest> {

	@Override
	protected AppointmentRequest invokeDataLayerToFetchSingleItem(AppointmentRequestDataLayer datalayer, PatientIdentifier patientIdentifier, String dataId, RequestMessage requestMessage) {
		return datalayer.fetchAppointmentRequest(patientIdentifier.getUniqueId(), dataId);
	}
}
