package com.agilex.healthcare.mobilehealthplatform.datalayer.appointment;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.AbstractFetchPatientDataListRequestHandler;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataFetchRequestReader;
import com.agilex.healthcare.mobilehealthplatform.domain.*;

/**
 * Created with IntelliJ IDEA.
 * User: clarkee
 * Date: 1/25/13
 * Time: 3:53 PM
 * To change this template use File | Settings | File Templates.
 */
public class FetchAppointmentRequestMessageListRequestHandler extends AbstractFetchPatientDataListRequestHandler<AppointmentRequestDataLayer, AppointmentRequestMessages, AppointmentRequestMessage> {

    @Override
    protected AppointmentRequestMessages invokeDataLayerToFetchList(AppointmentRequestDataLayer datalayer, RequestMessage requestMessage, PatientDataFetchRequestReader messageReader) {
        final String requestId = messageReader.getDataIdentifier().getUniqueId();
        final PatientIdentifier patientIdentifier = messageReader.getPatientIdentifier();
        final DataIdentifier dataIdentifier = messageReader.getDataIdentifier();
        final AppointmentRequestMessages messages = datalayer.fetchAppointmentRequestMessages(patientIdentifier.getUniqueId(), requestId);
        fixPatientAndDataIdentifier(messages, patientIdentifier, getSystem(dataIdentifier));
        return messages;
    }

    private String getSystem(DataIdentifier requestDateIdentifier) {
        return requestDateIdentifier.getSystemId();
    }

    private void fixPatientAndDataIdentifier(AppointmentRequestMessages messages, PatientIdentifier patientIdentifier, String systemId) {
        for (AppointmentRequestMessage message : messages) {
            message.setPatientIdentifier(patientIdentifier);
            message.getDataIdentifier().setSystemId(systemId);
        }
    }
}
