package com.agilex.healthcare.mobilehealthplatform.datalayer.appointment;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.AbstractFetchPatientDataListRequestHandler;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataFetchRequestReader;
import com.agilex.healthcare.mobilehealthplatform.domain.AppointmentRequest;
import com.agilex.healthcare.mobilehealthplatform.domain.AppointmentRequests;

public class FetchAppointmentRequestListRequestHandler extends AbstractFetchPatientDataListRequestHandler<AppointmentRequestDataLayer, AppointmentRequests, AppointmentRequest> {

	@Override
	protected AppointmentRequests invokeDataLayerToFetchList(AppointmentRequestDataLayer datalayer, RequestMessage requestMessage, PatientDataFetchRequestReader messageReader) {
		AppointmentRequests allAppointmentRequests = datalayer.fetchAppointmentRequestsByPatient(messageReader.getPatientId(), messageReader.getDateFilter());
		AppointmentRequests activeAppointmentRequests = new AppointmentRequests();
		
		for (AppointmentRequest appointmentRequest : allAppointmentRequests) {
			if (appointmentRequest.isActiveFlag()) {
				activeAppointmentRequests.add(appointmentRequest);
			}
		}
		
		return activeAppointmentRequests;
	}

}
