package com.agilex.healthcare.mobilehealthplatform.datalayer.appointment;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.AbstractFetchPatientDataListRequestHandler;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataFetchRequestReader;
import com.agilex.healthcare.mobilehealthplatform.domain.Appointment;
import com.agilex.healthcare.mobilehealthplatform.domain.Appointments;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterer;

public class FetchAppointmentListRequestHandler extends AbstractFetchPatientDataListRequestHandler<AppointmentDataLayer, Appointments, Appointment> {

	@Override
	protected Appointments invokeDataLayerToFetchList(AppointmentDataLayer datalayer, RequestMessage requestMessage, PatientDataFetchRequestReader messageReader) {
		boolean details = messageReader.shouldIncludeDetails();
		
		Appointments appointments = datalayer.fetchAppointmentsByPatient(messageReader.getPatientIdentifier(), messageReader.getDateFilter(), details);
		
		return DateFilterer.filterByDate(appointments, messageReader.getDateFilter());
	}

}
