package com.agilex.healthcare.mobilehealthplatform.datalayer.appointment;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestHandler;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.ResponseMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataResponseBuilder;
import com.agilex.healthcare.mobilehealthplatform.domain.AppointmentRequest;
import com.agilex.healthcare.mobilehealthplatform.domain.AppointmentRequests;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.DataSystem;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.DomainServiceRegistry;
import com.agilex.healthcare.mobilehealthplatform.utils.DefaultAssigningAuthorityUpdater;

public class AppointmentRequestSearchRequestHandler implements RequestHandler {
	private final static org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(AppointmentRequestSearchRequestHandler.class);
	
	@Override
	public ResponseMessage handle(RequestMessage requestMessage) {
		AppointmentRequestDataLayer datalayer = getDataLayer(requestMessage);

		AppointmentRequestSearchRequestReader messageReader = AppointmentRequestSearchRequestReader.fromRequest(requestMessage);
		AppointmentRequests appointmentRequests = datalayer.fetchAppointmentRequests(messageReader.getAppointmentRequestFilter());

		fixPatientAndDataIdentifier(requestMessage, appointmentRequests);
		
		return PatientDataResponseBuilder.fromPatientData(appointmentRequests).build();
	}

	private AppointmentRequestDataLayer getDataLayer(RequestMessage requestMessage) {
		DomainServiceRegistry serviceRegistry = new DomainServiceRegistry();
		return serviceRegistry.getDataLayerByMessage(requestMessage);
	}
	
	private void fixPatientAndDataIdentifier(RequestMessage requestMessage, AppointmentRequests appointmentRequests) {
		DomainServiceRegistry serviceRegistry = new DomainServiceRegistry();
		DataSystem system = serviceRegistry.getSystemByMessage(requestMessage);
		logger.debug("fixing the assiging authority for patients");
		
		for (AppointmentRequest appointmentRequest : appointmentRequests) {
			DefaultAssigningAuthorityUpdater.fillDefaultAssigningAuthority(appointmentRequest, system.getPatientAssigningAuthority());
			appointmentRequest.getDataIdentifier().setSystemId(system.getSystemIdentifier());
		}
	}
}
