package com.agilex.healthcare.mobilehealthplatform.datalayer.appointment;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataFetchRequestBuilder;

public class AppointmentRequestSearchRequestBuilder extends PatientDataFetchRequestBuilder {
	private AppointmentRequestSearchRequestBuilder(RequestMessage request) {
		super(request);
	}

	public static AppointmentRequestSearchRequestBuilder forRetrieveList() {
		RequestMessage request = new RequestMessage();
		AppointmentRequestSearchRequestBuilder builder = new AppointmentRequestSearchRequestBuilder(request);
		request.setType("AppointmentRequestSearch");
		return builder;
	}

	public PatientDataFetchRequestBuilder forAppointmentRequestFilter(AppointmentRequestFilter filter) {
		request.setValue("appointment-request-filter", filter);
		return this;
	}

    public static AppointmentRequestSearchRequestBuilder forRetrieveMessageList() {
        RequestMessage request = new RequestMessage();
        AppointmentRequestSearchRequestBuilder builder = new AppointmentRequestSearchRequestBuilder(request);
        request.setType("AppointmentRequestMessagesRetrieve");
        return builder;
    }
}
