package com.agilex.healthcare.mobilehealthplatform.datalayer.appointment;

import com.agilex.healthcare.mobilehealthplatform.domain.AppointmentRequestInProcess;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.MhpObjectFactory;

public class AppointmentRequestInProcessDataService {
	
	private AppointmentRequestInProcessDataLayer datalayer = null;
	
	public AppointmentRequestInProcessDataService() {
		datalayer = MhpObjectFactory.getInstance().getAppointmentRequestInProcessDataLayer();	
	}

	public AppointmentRequestInProcess fetchAppointmentRequestInProcessById(String appointmentRequestId) {
		return datalayer.fetchAppointmentRequestInProcessByAppointmentRequestId(appointmentRequestId);
	}

	public AppointmentRequestInProcess saveAppointmentRequestInProcess(AppointmentRequestInProcess appointmentRequestInProcess) {
		return datalayer.saveAppointmentRequestInProcess(appointmentRequestInProcess);
	}

	public void deleteAppointmentRequestInProcessById(String appointmentRequestId) {
		datalayer.deleteAppointmentRequestInProcessById(appointmentRequestId);
	}

	public void deleteAppointmentRequestInProcessByUserId(String id) {
		datalayer.deleteAppointmentRequestInProcessByUserId(id);
	}
	
}
