package com.agilex.healthcare.mobilehealthplatform.datalayer.appointment;

import com.agilex.healthcare.mobilehealthplatform.domain.AppointmentMetric;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.MhpObjectFactory;

public class AppointmentMetricsDataService {
	
	private AppointmentMetricsDataLayer datalayer = null;
	
	public AppointmentMetricsDataService() {
		datalayer = MhpObjectFactory.getInstance().getAppointmentMetricsDataLayer();	
	}
	
	public AppointmentMetric incrementMetric(String name) {

		AppointmentMetric metric = datalayer.getMetric(name);
		
		if (metric != null) {
			metric.setValue(metric.getValue() + 1);
		} else {
			metric = new AppointmentMetric();
			metric.setName(name);
			metric.setValue(1);
		}
		
		AppointmentMetric result = datalayer.saveMetric(metric);
		
		return result;
	}
}
