package com.agilex.healthcare.mobilehealthplatform.datalayer.antibiogram;

import com.agilex.healthcare.mobilehealthplatform.domain.antibiogram.*;
import com.agilex.healthcare.utility.NullChecker;

public class AntibiogramOrganismFilter {
	
	public Organisms filter(String term, Organisms organisms) {
		// return all if they did not pass a term
		if(NullChecker.isNullish(term))
			return organisms;

		term = term.toLowerCase();
		assert(organisms != null);
		
		Organisms filtered = new Organisms();
		for(Organism organism : organisms) {
			String organismName = organism.getName();
			
			if(NullChecker.isNullish(organismName)) 
				continue;
			
			organismName = organismName.toLowerCase();
			if(organismName.contains(term))
				filtered.add(organism);
		}
		
		return filtered;
	}
	
}
