package com.agilex.healthcare.mobilehealthplatform.datalayer.antibiogram;

import com.agilex.healthcare.mobilehealthplatform.domain.antibiogram.*;
import com.agilex.healthcare.utility.NullChecker;

public class AntibiogramFilter {

	public Organisms filter(Organisms organisms, String term) {
		if(NullChecker.isNullish(term))
			return organisms;
		
		term = term.toLowerCase();
		Organisms filtered = new Organisms();
		
		for(Organism organism : organisms) {
			String organismName = organism.getName();
			if(NullChecker.isNullish(organismName))
				continue;
			
			organismName = organismName.toLowerCase();
			if(organismName.contains(term)) 
				filtered.add(organism);
		}
		
		return filtered;
	}
	
	public OrganismGroups filter(OrganismGroups organismGroups, String term) {
		if(NullChecker.isNullish(term))
			return organismGroups;
		
		term = term.toLowerCase();
		OrganismGroups filtered = new OrganismGroups();
		
		for(OrganismGroup organismGroup : organismGroups) {
			String organismGroupName = organismGroup.getName();
			if(NullChecker.isNullish(organismGroupName))
				continue;
			
			organismGroupName = organismGroupName.toLowerCase();
			if(organismGroupName.contains(term)) 
				filtered.add(organismGroup);
		}
		
		return filtered;
	}	
}
