package com.agilex.healthcare.mobilehealthplatform.datalayer.antibiogram;

import java.util.ArrayList;
import java.util.List;

import com.agilex.healthcare.mobilehealthplatform.domain.antibiogram.AntibiogramMatrix;
import com.agilex.healthcare.mobilehealthplatform.domain.antibiogram.AntibiogramSummaries;
import com.agilex.healthcare.mobilehealthplatform.domain.antibiogram.OrganismGroups;
import com.agilex.healthcare.mobilehealthplatform.domain.antibiogram.Organisms;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.MhpObjectFactory;

public class AntibiogramDataService {

	AntibiogramDataLayer dataLayer = null;
	//AntibiogramDataLayer organismGroupDataLayer = null;

	public AntibiogramDataService() {
		dataLayer = MhpObjectFactory.getInstance().getAntibiogramDataLayer();
		//organismGroupDataLayer = MhpObjectFactory.getInstance().getOrganismGroupDataLayer();
	}

	public Organisms fetchOrganisms(String facilitySiteCode, String term) {
		Organisms organisms = dataLayer.fetchOrganisms(facilitySiteCode);
		return filter(organisms, term);
	}
	
	public OrganismGroups fetchOrganismGroups(String facilitySiteCode, String term) {
		//OrganismGroups organismGroups = organismGroupDataLayer.fetchOrganismGroups(facilitySiteCode);
		OrganismGroups organismGroups = dataLayer.fetchOrganismGroups(facilitySiteCode);
		return filter(organismGroups, term);
	}
	
	public AntibiogramSummaries fetchSummariesByGroup(String facilitySiteCode, String groupId, DateFilter dateFilter) {
		//List<String> organismIds = organismGroupDataLayer.fetchOrganismsByGroup(facilitySiteCode, groupId);
		List<String> organismIds = dataLayer.fetchOrganismsByGroup(facilitySiteCode, groupId);
		AntibiogramSummaries summaries = dataLayer.fetchSummaries(facilitySiteCode, organismIds, dateFilter);
		return summaries;
	}	
	
	public AntibiogramSummaries fetchSummaries(String facilitySiteCode, String organismId, DateFilter dateFilter) {
		List<String> organismIds = new ArrayList<String>();
		organismIds.add(organismId);
		AntibiogramSummaries summaries = dataLayer.fetchSummaries(facilitySiteCode, organismIds, dateFilter);
		return summaries;
	}

	public AntibiogramMatrix fetchMatrix(String facilitySiteCode, DateFilter dateFilter) {
		AntibiogramMatrix antibiogramMatrix = dataLayer.fetchMatrix(facilitySiteCode, dateFilter);
		return antibiogramMatrix;
	}
		
	private Organisms filter(Organisms organisms, String term) {
		AntibiogramFilter filter = new AntibiogramFilter();
		return filter.filter(organisms, term);
	}
	
	private OrganismGroups filter(OrganismGroups organismGroups, String term) {
		AntibiogramFilter filter = new AntibiogramFilter();
		return filter.filter(organismGroups, term);
	}	

}
