package com.agilex.healthcare.mobilehealthplatform.datalayer.allergy;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.AbstractFetchPatientDataListRequestHandler;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataFetchRequestReader;
import com.agilex.healthcare.mobilehealthplatform.domain.Allergies;
import com.agilex.healthcare.mobilehealthplatform.domain.Allergy;

public class FetchAllergyListRequestHandler extends AbstractFetchPatientDataListRequestHandler<AllergyDataLayer, Allergies, Allergy> {

	@Override
	protected Allergies invokeDataLayerToFetchList(AllergyDataLayer datalayer, RequestMessage requestMessage, PatientDataFetchRequestReader messageReader) {
		return datalayer.fetchAllergies(messageReader.getPatientIdentifier(), messageReader.getDateFilter());
	}

}
