package com.agilex.healthcare.mobilehealthplatform.datalayer.allergy;

import java.util.Collections;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.ResponseMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.Router;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataFetchRequestBuilder;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataResponseReader;
import com.agilex.healthcare.mobilehealthplatform.domain.Allergies;
import com.agilex.healthcare.mobilehealthplatform.domain.Allergy;
import com.agilex.healthcare.mobilehealthplatform.domain.DataIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifiers;
import com.agilex.healthcare.mobilehealthplatform.domain.RadiologyResults;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.MhpObjectFactory;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;
import com.agilex.healthcare.mobilehealthplatform.utils.PatientIdentifierHelper;
import com.agilex.healthcare.utility.NullChecker;
import com.agilex.healthcare.vamf.cdw.allergy.CdwAllergyDataLayer;


public class AllergyDataService {

	private Router router;
	private CdwAllergyDataLayer layer;

	public AllergyDataService() {
		this.router = new Router();
		this.layer = MhpObjectFactory.getInstance().getCdwAllergyDataLayer();
	}

	public AllergyDataService(Router router) {
		this.router = new Router();
		this.layer = MhpObjectFactory.getInstance().getCdwAllergyDataLayer();
	}

	public Allergies fetchPatientAllergies(PatientIdentifier patientIdentifier) {
		return fetchPatientAllergies(patientIdentifier, ScopeFilter.getInstanceForLongitudinalScope());
	}

	public Allergies fetchPatientAllergies(PatientIdentifier patientIdentifier, DateFilter dateFilter, ScopeFilter scopeFilter) {
		PatientIdentifiers dfnPatientIdentifiers = PatientIdentifierHelper.translatePatientIdentifier(patientIdentifier, "dfn");
		if(NullChecker.isNullish(dfnPatientIdentifiers))
			return new Allergies();
		/*RequestMessage request = PatientDataFetchRequestBuilder.forRetrieveList().forDomain(Domain.allergy).forPatientIdentifier(patientIdentifier).forDateFilter(dateFilter).forScopeFilter(scopeFilter).build();
		ResponseMessage responseMessage = router.execute(request);
		Allergies allergies = PatientDataResponseReader.<Allergies, Allergy> fromResponse(responseMessage).getDataListNoNull(Allergies.class);*/
		Allergies allergies = this.layer.fetchAllergies(PatientIdentifierHelper.getDfnPatientidentifierForQuery(dfnPatientIdentifiers), dateFilter);
		PatientIdentifierHelper.updatePatientIdentifier(allergies, patientIdentifier);
		Collections.sort(allergies);
		return allergies;
	}
	
	/**
	 * Please transition to using the signature with {@link DateFilter}
	 */
	@Deprecated
	public Allergies fetchPatientAllergies(PatientIdentifier patientIdentifier, ScopeFilter scopeFilter) {
		RequestMessage request = PatientDataFetchRequestBuilder.forRetrieveList().forDomain(Domain.allergy).forPatientIdentifier(patientIdentifier).forScopeFilter(scopeFilter).build();
		ResponseMessage responseMessage = router.execute(request);
		Allergies allergies = PatientDataResponseReader.<Allergies, Allergy> fromResponse(responseMessage).getDataListNoNull(Allergies.class);
		Collections.sort(allergies);
		return allergies;
	}

	public Allergy fetchAllergy(PatientIdentifier patientIdentifier, DataIdentifier dataIdentifier) {
		throw new UnsupportedOperationException();
		// While this is a common operation on other domains, the need for this method has not been established. The code below should be valid but should be considered untested.
//		RequestMessage request = PatientDataFetchRequestBuilder.forRetrieveSingleById().forDomain(Domain.allergy).forPatientIdentifier(patientIdentifier).forDataIdentifier(dataIdentifier).build();
//		ResponseMessage responseMessage = router.execute(request);
//		Allergy allergy = PatientDataResponseReader.<Allergies, Allergy> fromResponse(responseMessage).getDataItem();
//		return allergy;
	}

}
